<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proponentes extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('proponentes/Proponentes_model');
        $this->lang->load('proponentes/proponentes');



        /* Titulo de la pagina :: Common */
        $this->page_title->push(lang('proponentes/menu_proponentes'));
        $this->data['pagetitle'] = $this->page_title->show();

      	if ($_SESSION['id_modulo'] != 'PROPONENTES') {
			$_SESSION['arraywhere_proponentes'] 		= NULL;
			$_SESSION['arraywhere_proponentes_busq'] 	= NULL;
			$_SESSION['id_modulo'] = 'PROPONENTES';
		}

        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_proponentes'), 'proponentes/Proponentes');
    }

// nuevo

// fin nuevo
	public function index()
	{
		//Abstraer con las vistas dinamicas. Jaime
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}else{

						
			$user_id= $this->session->userdata('user_id');
			$tipo_usuario = $_SESSION['tipo_usuario'][0];
			$id_cliente = $_SESSION['id_cliente'][0];

			if ($tipo_usuario == 'C' && !$_POST) {
				$arraywhere = $_SESSION['arraywhere_proponentes'];
				$arraywherebusq = $_SESSION['arraywhere_proponentes_busq'];					

				if (isset($id_cliente) && !empty($id_cliente)) {
					$arraywhere['id_cliente'] = $id_cliente;
					$arraywherebusq['id_cliente'] = $id_cliente;
				} else {
					echo 'Error: id_cliente no está configurado en la sesión.';
					exit();
				}
				$_SESSION['arraywhere_proponentes'] = $arraywhere;
				$_SESSION['arraywhere_proponentes_busq'] = $arraywherebusq;					
			}			

      		if ($_POST) {
        		//$arraywhere = NULL;

				if ($_POST['id_proponente']) 
				{
					if (is_numeric($_POST['id_proponente'])) {
						$arraywhere['id_proponente'] 					            = $_POST['id_proponente'];
						$arraywherebusq['cast(id_proponente as varchar) like '] 	= '%'.$_POST['id_proponente'].'%';
					}
				}   	
				if ($_POST['des_tipo_persona']) 
				{
					$arraywhere['des_tipo_persona'] 					        	= $_POST['des_tipo_persona'];
					$arraywherebusq['lower(des_tipo_persona) like '] 				= '%'.strtolower($_POST['des_tipo_persona']).'%';
				}							     		
				if ($_POST['cedularuc']) 
				{
					if (is_numeric($_POST['cedularuc'])) {
						$arraywhere['cedularuc'] 					       			= $_POST['cedularuc'];
						$arraywherebusq['cast(cedularuc as varchar) like '] 		= '%'.$_POST['cedularuc'].'%';
					}
				}	
				if ($_POST['nombre']) 
				{
					$arraywhere['nombre'] 					        				= $_POST['nombre'];
					$arraywherebusq['lower(nombre) like '] 							= '%'.strtolower($_POST['nombre']).'%';
				}							
				if ($_POST['apellido']) 
				{
					$arraywhere['apellido'] 					        			= $_POST['apellido'];
					$arraywherebusq['lower(apellido) like '] 						= '%'.strtolower($_POST['apellido']).'%';
				}				
				if ($_POST['email']) 
				{
					$arraywhere['email'] 					        				= $_POST['email'];
					$arraywherebusq['lower(email) like '] 							= '%'.strtolower($_POST['email']).'%';
				}	
				if ($_POST['des_fecha_nac']) 
				{
					$arraywhere['des_fecha_nac'] 					        		= $_POST['des_fecha_nac'];
					$arraywherebusq['lower(des_fecha_nac) like '] 					= '%'.strtolower($_POST['des_fecha_nac']).'%';
				}
				if ($_POST['des_sexo']) 
				{
					$arraywhere['des_sexo'] 					        			= $_POST['des_sexo'];
					$arraywherebusq['lower(des_sexo) like '] 						= '%'.strtolower($_POST['des_sexo']).'%';
				}											
				if ($_POST['telefono']) 
				{
					$arraywhere['telefono'] 					        			= $_POST['telefono'];
					$arraywherebusq['lower(telefono) like '] 						= '%'.strtolower($_POST['telefono']).'%';
				}
				if ($_POST['direccion']) 
				{
					$arraywhere['direccion'] 					        			= $_POST['direccion'];
					$arraywherebusq['lower(direccion) like '] 						= '%'.strtolower($_POST['direccion']).'%';
				}

				if ($_POST['des_tipo_empresa']) 
				{
					$arraywhere['des_tipo_empresa'] 								= $_POST['des_tipo_empresa'];
					$arraywherebusq['lower(des_tipo_empresa) like '] 				= '%'.strtolower($_POST['des_tipo_empresa']).'%';
				}												

				if ($_POST['nacionalidad']) 
				{
					$arraywhere['nacionalidad'] 									= $_POST['nacionalidad'];
					$arraywherebusq['lower(nacionalidad) like ']					= '%'.strtolower($_POST['nacionalidad']).'%';
				}

				if ($_POST['rlegal_cedula']) {
					if (is_numeric($_POST['cedularuc'])) {
						$arraycampos['rlegal_cedula'] 									= $_POST['rlegal_cedula'];
						$arraywherebusq['lower(rlegal_cedula) like ']					= '%'.strtolower($_POST['rlegal_cedula']).'%';
					}
                }

                if ($_POST['rlegal_nombre']) {
                    $arraycampos['rlegal_nombre'] 									= $_POST['rlegal_nombre'];
					$arraywherebusq['lower(rlegal_nombre) like ']					= '%'.strtolower($_POST['rlegal_nombre']).'%';
                }

                if ($_POST['rlegal_apellido']) {
                    $arraycampos['rlegal_apellido'] 								= $_POST['rlegal_apellido'];
					$arraywherebusq['lower(rlegal_apellido) like ']					= '%'.strtolower($_POST['rlegal_apellido']).'%';
                }

                if ($_POST['rlegal_sexo']) {
                    $arraycampos['rlegal_sexo'] 									= $_POST['rlegal_sexo'];
					$arraywherebusq['lower(rlegal_sexo) like ']					    = '%'.strtolower($_POST['rlegal_sexo']).'%';
                }


				$_SESSION['arraywhere_proponentes	'] = $arraywhere;
				$_SESSION['arraywhere_proponentes_busq'] = $arraywherebusq;


				redirect('proponentes/Proponentes/index');				
			}

			$user_id= $this->session->userdata('user_id');
			$tipo_usuario = $_SESSION['tipo_usuario'][0];
			$id_cliente = $_SESSION['id_cliente'][0];

			if ($tipo_usuario == 'C' && !$_POST) {
				$arraywhere = $_SESSION['arraywhere_proponentes'];
				$arraywherebusq = $_SESSION['arraywhere_proponentes_busq'];					

				if (isset($id_cliente) && !empty($id_cliente)) {
					$arraywhere['id_cliente'] = $id_cliente;
					$arraywherebusq['id_cliente'] = $id_cliente;
				} else {
					echo 'Error: id_cliente no está configurado en la sesión.';
					exit();
				}
				$_SESSION['arraywhere_proponentes'] = $arraywhere;
				$_SESSION['arraywhere_proponentes_busq'] = $arraywherebusq;					
			}
			

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'proponentes/Proponentes/index/',  // url completa de la pagina paginada
				'v_proponentes_index',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_proponentes_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['proponentes']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				5,								// segmento uri a leer
 				'v_proponentes_index',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_proponentes_busq']
 				)->result();
			// ----- Fin paginacion

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs - Miga de pan */
			$this->data['breadcrumb'] 	= $this->breadcrumbs->show();

			/* Cargar plantilla predefinida */
			$this->template->admin_render('proponentes/index', $this->data);
		}
	}

	


	//////----------------------------------------//////
	//////                 create()               //////
	//////----------------------------------------//////

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proponentes'), 'proponentes/Proponentes/index');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();



		/* Validate form input */
		//$this->form_validation->set_rules('id_proponente' , 'lang:proponentes_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('cedularuc' , 'lang:proponentes_cedularuc' , 'is_numeric|min_length[4]|max_length[9]|regex_match[/^([0-9]{4,9})?$/]');
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('apellido' , 'lang:proponentes_apellido' , 'max_length[100]');
		$this->form_validation->set_rules('email' , 'lang:proponentes_email' , 'max_length[100]');
		$this->form_validation->set_rules('fecha_nac', 'Date');   
		$this->form_validation->set_rules('sexo' , 'lang:proponentes_sexo' , 'max_length[1]');
		$this->form_validation->set_rules('tipo_persona' , 'lang:proponentes_tipo_persona' , 'max_length[1]');
		$this->form_validation->set_rules('telefono' , 'lang:proponentes_telefono' , 'max_length[30]');
		$this->form_validation->set_rules('direccion' , 'lang:proponentes_direccion' , 'max_length[100]');
		$this->form_validation->set_rules('tipo_empresa' , 'lang:proponentes_tipo_empresa' , 'max_length[1]');
		$this->form_validation->set_rules('nacionalidad' , 'lang:proponentes_nacionalidad' , 'max_length[30]');
		$this->form_validation->set_rules('rlegal_cedula', 'lang:proponentes_rlegal_cedula', 'max_length[10]');
        $this->form_validation->set_rules('rlegal_nombre', 'lang:proponentes_rlegal_nombre', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_apellido', 'lang:proponentes_rlegal_apellido', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_sexo', 'lang:proponentes_rlegal_sexo', 'max_length[1]');
	
		if ($this->form_validation->run() == TRUE)
		{			
			if (isset($_POST) && ! empty($_POST)) 
			{ 

				//if ($_POST['id_proponente']) {
					//$arraycampos['id_proponente']				= $_POST['id_proponente'];
				//}

				if ($_POST['cedularuc']) {
					$arraycampos['cedularuc']					= $_POST['cedularuc'];
				}else{
					$arraycampos['cedularuc']					= NULL;
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']						= $_POST['nombre'];
				}

				if ($_POST['apellido']) {
					$arraycampos['apellido']					= $_POST['apellido'];
				}

				if ($_POST['email']) {
					$arraycampos['email']						= $_POST['email'];
				}

				if ($_POST['fecha_nac']) {
					$arraycampos['fecha_nac']					= $_POST['fecha_nac'];
				}

				if ($_POST['dp_sexo']) {
					$arraycampos['sexo']						= $_POST['dp_sexo'];
				}

				if ($_POST['dp_tipo_persona']) {
					$arraycampos['tipo_persona']				= $_POST['dp_tipo_persona'];
				}

				if ($_POST['telefono']) {
					$arraycampos['telefono']					= $_POST['telefono'];
				}

				if ($_POST['direccion']) {
					$arraycampos['direccion']					= $_POST['direccion'];
				}

				if ($_POST['tipo_empresa']) {
					$arraycampos['tipo_empresa']				= $_POST['tipo_empresa'];
				}

				if ($_POST['nacionalidad']) {
					$arraycampos['nacionalidad']				= $_POST['nacionalidad'];
				}

				if ($_POST['rlegal_cedula']) {
					$arraycampos['rlegal_cedula']               = $_POST['rlegal_cedula'];
				}
	
				if ($_POST['rlegal_nombre']) {
					$arraycampos['rlegal_nombre']               = $_POST['rlegal_nombre'];
				}
	
				if ($_POST['rlegal_apellido']) {
					$arraycampos['rlegal_apellido'] 			= $_POST['rlegal_apellido'];
				}
	
				if ($_POST['dp_rlegal_sexo']) {
					$arraycampos['rlegal_sexo'] 				= $_POST['dp_rlegal_sexo'];
				}

				$arraycampos['id_proponente'] = $this->Proponentes_model->obtener_nextval('ema.proponentes_id_proponente_seq');

				$new_proponentes_id = $this->Proponentes_model->create_proponentes($arraycampos);
				if ($new_proponentes_id)
				{
					$this->session->set_flashdata('message', $this->ion_auth->messages());
					redirect('proponentes/proponentes/index');
				}
			}
		}else{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			//creando campos
			$this->data['id_proponente'] = array(
				'type'		=> 'text',
				'name'		=> 'id_proponente',
				'id'		=> 'id_proponente',
				'value'		=> $this->form_validation->set_value('id_proponente'),
				//'data-src'	=> $proponentes->id_proponente,
				'class'		=> 'form-control',
				'disabled'	=> true
			);
			 
			$this->data['cedularuc'] = array(
				'type'		=> 'number',
				'name'      => 'cedularuc',
				'id'        => 'cedularuc',
				'pattern'   => '^[0-9]{4,9}$',
				'minlength' => '4',	
				'maxlength' => '9',				
				'value'     => $this->form_validation->set_value('cedularuc'),
				//'data-src'	=> $proponentes->cedularuc,
				'class'     => 'form-control',
				'required'  => false
			);

			$this->data['nombre'] = array(
				'type'		=> 'text',
				'name'		=> 'nombre',
				'id'		=> 'nombre',
				'maxlength'	=> '100',
				'value'		=> $this->form_validation->set_value('nombre'),
				//'data-src'	=> $proponentes->nombre,
				'class'		=> 'form-control',
				'required'  => 'false'
			);

			$this->data['apellido'] = array(
				'type'		=> 'text',
				'name'		=> 'apellido',
				'id'		=> 'apellido',
				'maxlength'	=> '100',
				'value'		=> $this->form_validation->set_value('apellido'),
				//'data-src'	=> $proponentes->apellido,
				'class'		=> 'form-control',
				'required'  => 'false'
			);

			$this->data['email'] = array(
				'type'     => 'text',
				'name'     => 'email',
				'id'       => 'email',
				'maxlength' => '100',
				'value'    => $this->form_validation->set_value('email'),
				//'data-src' => $proponentes->email,
				'class'    => 'form-control'
			);

			$this->data['fecha_nac'] = array(
				'type'     => 'text',
				'name'     => 'fecha_nac',
				'id'       => 'fecha_nac',
				'value'    => $this->form_validation->set_value('fecha_nac'),
				//'data-src' => $proponentes->fecha_nac,
				'class'    => 'form-control'
			);	

			$d_sexo = $this->Proponentes_model->concepto('SEXO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_sexo as $r_sexo) {
				$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
			}
			$this->data['sexo'] = $a_sexo;


			$d_tipopersona = $this->Proponentes_model->concepto('TIPO_PERSONA', false, 'CONCEPTO')->result_array();

			// Inserta en un array asociativo para el form_dropdown
			$a_tipopersona = [];
			foreach ($d_tipopersona as $r_tipopersona) {
				$a_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'] . ' - ' . $r_tipopersona['nombre'];
			}

			// Asignar opciones al dropdown
			$this->data['tipo_persona'] = $a_tipopersona;

			// Establecer la primera opción como predeterminada si no hay un valor preexistente
			$this->data['tipo_persona_sel'] = key($a_tipopersona);


			$this->data['telefono'] = array(
				'type'     => 'text',
				'name'     => 'telefono',
				'id'       => 'telefono',
				'value'    => $this->form_validation->set_value('telefono'),
				//'data-src' => $proponentes->telefono,
				'class'    => 'form-control'
			);	

			$this->data['direccion'] = array(
				'type'     => 'text',
				'name'     => 'direccion',
				'id'       => 'direccion',
				'value'    => $this->form_validation->set_value('direccion'),
				//'data-src' => $proponentes->dirección,
				'class'    => 'form-control'
			);	

			$d_tipoempresa = $this->Proponentes_model->concepto('TIPO_EMPRESA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_tipoempresa as $r_tipoempresa) {
				$a_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'].' - '.$r_tipoempresa['nombre'];
			}
			$this->data['tipo_empresa'] = $a_tipoempresa;

			$a_clientes[''] = 'Seleccione el Cliente';
			$d_clientes = $this->Proponentes_model->dropdown_data('cliente')->result_array();

			foreach ($d_clientes as $r_cliente) {
				$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'] . ' - ' . $r_cliente['nombre'];
			}

			$this->data['cliente'] = $a_clientes;

			$this->data['nacionalidad'] = array(
				'type'     => 'text',
				'name'     => 'nacionalidad',
				'id'       => 'nacionalidad',
				'value'    => $this->form_validation->set_value('nacionalidad'),
				//'data-src' => $proponentes->nacionalidad,
				'class'    => 'form-control'
			);
			
			/* INICIO - Agregando los campos adicionales*/
			$this->data['rlegal_cedula'] = array(
				'type'		=> 'number',
				'name'      => 'rlegal_cedula',
				'id'        => 'rlegal_cedula',
				'pattern'   => '^[0-9]{4,9}$',
				'minlength' => '4',	
				'maxlength' => '9',				
				'value'     => $this->form_validation->set_value('rlegal_cedula'),
				//'data-src'	=> $proponentes->rlegal_cedula,
				'class'     => 'form-control',
				'required'  => 'true'
			);

			$this->data['rlegal_nombre'] = array(
				'type'		=> 'text',
				'name'		=> 'rlegal_nombre',
				'id'		=> 'rlegal_nombre',
				'maxlength'	=> '100',
				'value'		=> $this->form_validation->set_value('rlegal_nombre'),
				//'data-src'	=> $proponentes->rlegal_nombre,
				'class'		=> 'form-control'
			);

			$this->data['rlegal_apellido'] = array(
				'type'		=> 'text',
				'name'		=> 'rlegal_apellido',
				'id'		=> 'rlegal_apellido',
				'maxlength'	=> '100',
				'value'		=> $this->form_validation->set_value('rlegal_apellido'),
				//'data-src'	=> $proponentes->rlegal_apellido,
				'class'		=> 'form-control'
			);

			$d_sexo = $this->Proponentes_model->concepto('RLEGAL_SEXO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_sexo as $r_sexo) {
				$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
			}
			$this->data['rlegal_sexo'] = $a_sexo;


			/* FIN - Agregando los campos adicionales*/

			/* Load Template */
			$this->template->admin_render('proponentes/create', $this->data);
		}
	}


	// Función de validación personalizada
    public function valid_date($v_date) {
        // Validar la fecha en formato dd/mm/yyyy
        $d = DateTime::createFromFormat('d/m/Y', $v_date);
		/*
	        echo '<pre>';
	        print_r( $v_date );
	        echo '</pre>';
	        show_error(1); 
		*/
        if ($v_date == '') {
        	return TRUE;
        } else { 		
	        if ($d !== false) {
    	    //if (preg_match('/\d{2}-\d{2}-\d{4}/', $d1)) {
        	    // Verificar si la fecha es válida
            	//$d = DateTime::createFromFormat('d-m-Y', $d1);
            	//return $d && $d->format('d-m-Y') === $d1;
            	return $d->format('d-m-Y');
        	} else {
            	$this->form_validation->set_message('valid_date', 'El campo {field} debe contener una fecha válida en formato dd/mm/yyyy.');
            	return FALSE;
        	}
        }
    }


	//////----------------------------------------//////
	//////                 edit()               //////
	//////----------------------------------------//////

	public function edit($proponente)
	{


		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $proponente OR empty($proponente))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proponentes_edit'), 'proponentes/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$proponentes = $this->Proponentes_model->view('proponentes', array('id_proponente' => $proponente))->row();

		/* Validate form input */
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('cedularuc' , 'lang:proponentes_cedularuc' , 'is_numeric|min_length[4]|max_length[9]|regex_match[/^([0-9]{4,9})?$/]');
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('apellido' , 'lang:proponentes_apellido' , 'max_length[100]');
		$this->form_validation->set_rules('email' , 'lang:proponentes_email' , 'max_length[100]');
		$this->form_validation->set_rules('fecha_nac', 'Date', 'callback_valid_date');
		$this->form_validation->set_rules('sexo' , 'lang:proponentes_sexo' , 'max_length[1]');
		$this->form_validation->set_rules('tipo_persona' , 'lang:proponentes_tipo_persona' , 'max_length[1]');
		$this->form_validation->set_rules('telefono' , 'lang:proponentes_telefono' , 'max_length[30]');
		$this->form_validation->set_rules('direccion' , 'lang:proponentes_direccion' , 'max_length[100]');
		$this->form_validation->set_rules('tipo_empresa' , 'lang:proponentes_tipo_empresa' , 'max_length[1]');
		$this->form_validation->set_rules('nacionalidad' , 'lang:proponentes_nacionalidad' , 'max_length[30]');
		$this->form_validation->set_rules('rlegal_cedula', 'Representante Legal Cedula', 'max_length[10]');
        $this->form_validation->set_rules('rlegal_nombre', 'Representante Legal Nombre', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_apellido', 'Representante Legal Apellido', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_sexo', 'Representante Legal Sexo', 'max_length[1]');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{

				/*if ($_POST['id_proponente']) {
					$arraycampos['id_proponente']					= strtoupper($_POST['id_proponente']);
				}
				*/

				if ($_POST['cedularuc']) {
					$arraycampos['cedularuc']					= $_POST['cedularuc'];
				}else{
					$arraycampos['cedularuc']					= NULL;
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']						= $_POST['nombre'];
				}else{
					$arraycampos['nombre']					= NULL;
				}	

				if ($_POST['apellido']) {
					$arraycampos['apellido']					= $_POST['apellido'];
				}else{
					$arraycampos['apellido']					= NULL;
				}

				if ($_POST['email']) {
					$arraycampos['email']						= $_POST['email'];
				}else{
					$arraycampos['email']					= NULL;
				}

				if ($_POST['fecha_nac']) {
					$arraycampos['fecha_nac']					= $_POST['fecha_nac'];
				} else {
					$arraycampos['fecha_nac']					= NULL;  
				}


				if ($_POST['dp_sexo']) {
					$arraycampos['sexo']						= $_POST['dp_sexo'];
				}else{
					$arraycampos['sexo']					= NULL;
				} 

				if ($_POST['dp_clientes']) {
					$arraycampos['id_cliente']		= $_POST['dp_clientes'];
				}else{
					$arraycampos['id_cliente']		= 	NULL;
				}


				if ($_POST['dp_tipo_persona']) {
					$arraycampos['tipo_persona']				= $_POST['dp_tipo_persona'];
				}else{
					$arraycampos['tipo_persona']					= NULL;
				}


				if ($_POST['telefono']) {
					$arraycampos['telefono']					= $_POST['telefono'];
				}else{
					$arraycampos['telefono']					= NULL;
				}


				if ($_POST['direccion']) {
					$arraycampos['direccion']					= $_POST['direccion'];
				}else{
					$arraycampos['direccion']					= NULL;
				}


				if ($_POST['dp_tipo_empresa']) {
					$arraycampos['tipo_empresa']				= $_POST['dp_tipo_empresa'];
				}else{
					$arraycampos['tipo_empresa']					= NULL;
				}


				if ($_POST['nacionalidad']) {
					$arraycampos['nacionalidad']				= $_POST['nacionalidad'];
				}else{
					$arraycampos['nacionalidad']					= NULL;
				}

				if ($_POST['rlegal_cedula']) {
					$arraycampos['rlegal_cedula']               = $_POST['rlegal_cedula'];
				}else{
					$arraycampos['rlegal_cedula']					= NULL;
				}
	
				if ($_POST['rlegal_nombre']) {
					$arraycampos['rlegal_nombre'] 				= $_POST['rlegal_nombre'];
				}else{
					$arraycampos['rlegal_nombre']					= NULL;
				}
	
				if ($_POST['rlegal_apellido']) {
					$arraycampos['rlegal_apellido'] 			= $_POST['rlegal_apellido'];
				}else{
					$arraycampos['rlegal_apellido']					= NULL;
				}
	
				if ($_POST['dp_rlegal_sexo']) {
					$arraycampos['rlegal_sexo'] 				= $_POST['dp_rlegal_sexo'];
				}else{
					$arraycampos['rlegal_sexo']					= NULL;
				}
	
			/*
	        echo '<pre>';
	        print_r( $arraycampos );
	        echo '</pre>';
	        show_error(1); 
			*/
				$proponente_update = $this->Proponentes_model->update_proponentes($proponentes->id_proponente,$arraycampos);

				if ($proponente_update)
				{

					$this->session->set_flashdata('message', $this->lang->line('proponentes_update_successful'));
					redirect('proponentes/Proponentes/edit/'.$proponentes->id_proponente); 
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['proponentes']   = $proponentes;

		//creando campos
		$this->data['id_proponente'] = array(
			'type'     => 'text',
			'name'     => 'id_proponente',
			'id'       => 'id_proponente',
			'value'    => $this->form_validation->set_value('id_proponente', $proponentes->id_proponente),
			'data-src' => $proponentes->id_proponente,
			'class'    => 'form-control',
			'disabled'    => true
		);
		 
		$this->data['cedularuc'] = array(
			'type'     => 'text',
			'name'     => 'cedularuc',
			'id'       => 'cedularuc',
			'value'    => $this->form_validation->set_value('cedularuc', $proponentes->cedularuc),
			'data-src' => $proponentes->cedularuc,
			'class'    => 'form-control'
		);

		$this->data['nombre'] = array(
			'type'     => 'text',
			'name'     => 'nombre',
			'id'       => 'nombre',
			'value'    => $this->form_validation->set_value('nombre', $proponentes->nombre),
			'data-src' => $proponentes->nombre,
			'class'    => 'form-control'
		);

		$this->data['apellido'] = array(
			'type'     => 'text',
			'name'     => 'apellido',
			'id'       => 'apellido',
			'value'    => $this->form_validation->set_value('apellido', $proponentes->apellido),
			'data-src' => $proponentes->apellido,
			'class'    => 'form-control'
		);

		$this->data['email'] = array(
			'type'     => 'text',
			'name'     => 'email',
			'id'       => 'email',
			'value'    => $this->form_validation->set_value('email', $proponentes->email),
			'data-src' => $proponentes->email,
			'class'    => 'form-control'
		);	

		$this->data['fecha_nac'] = array(
			'type'     => 'text',
			'name'     => 'fecha_nac',
			'id'       => 'fecha_nac',
			'value'    => $this->form_validation->set_value('fecha_nac', formato_fecha($proponentes->fecha_nac)),
			'data-src' => $proponentes->fecha_nac,
			'class'    => 'form-control'
		);		

		$d_sexo = $this->Proponentes_model->concepto('SEXO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_sexo as $r_sexo) {
			$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
		}
		$this->data['sexo'] = $a_sexo;
		$this->data['sexo_sel'] = $proponentes->sexo;	

		$d_tipopersona = $this->Proponentes_model->concepto('TIPO_PERSONA',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_tipopersona as $r_tipopersona) {
			$a_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'].' - '.$r_tipopersona['nombre'];
		}
		$this->data['tipo_persona'] = $a_tipopersona;
		$this->data['tipo_persona_sel'] = $proponentes->tipo_persona;	

		$this->data['telefono'] = array(
			'type'     => 'text',
			'name'     => 'telefono',
			'id'       => 'telefono',
			'value'    => $this->form_validation->set_value('telefono', $proponentes->telefono),
			'data-src' => $proponentes->telefono,
			'class'    => 'form-control'
		);		

		$this->data['direccion'] = array(
			'type'     => 'text',
			'name'     => 'direccion',
			'id'       => 'direccion',
			'value'    => $this->form_validation->set_value('direccion', $proponentes->direccion),
			'data-src' => $proponentes->direccion,
			'class'    => 'form-control'
		);		

		$d_tipoempresa = $this->Proponentes_model->concepto('TIPO_EMPRESA',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_tipoempresa as $r_tipoempresa) {
			$a_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'].' - '.$r_tipoempresa['nombre'];
		}
		$this->data['tipo_empresa'] = $a_tipoempresa;
		$this->data['tipo_empresa_sel'] = $proponentes->tipo_empresa;	
			
		$a_clientes[''] = 'Seleccione el Cliente';
		$d_clientes = $this->Proponentes_model->dropdown_data('cliente')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_clientes as $r_cliente) {
			$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'].' - '.$r_cliente['nombre'].' '.$r_cliente['apellido'];
		}
		$this->data['cliente'] = $a_clientes;
		$this->data['cliente_sel'] = $proponentes->id_cliente;

		$this->data['nacionalidad'] = array(
			'type'     => 'text',
			'name'     => 'nacionalidad',
			'id'       => 'nacionalidad',
			'value'    => $this->form_validation->set_value('nacionalidad', $proponentes->nacionalidad),
			'data-src' => $proponentes->nacionalidad,
			'class'    => 'form-control'
		);
		
		/* INICIO - Agregando campos adicionales @Kevin Adorno*/
		

		$this->data['rlegal_cedula'] = array(
			'type'      => 'number',
			'name'      => 'rlegal_cedula',
			'id'        => 'rlegal_cedula',
			'pattern'   => '^[0-9]{4,9}$',
			'minlength' => '4',	
			'maxlength' => '9',	
			'value'     => $this->form_validation->set_value('rlegal_cedula', $proponentes->rlegal_cedula),
			'data-src'  => $proponentes->rlegal_cedula,
			'class'     => 'form-control',
			'required'  => 'true'
		);

		$this->data['rlegal_nombre'] = array(
			'type'		=> 'text',
			'name'		=> 'rlegal_nombre',
			'id'		=> 'rlegal_nombre',
			'maxlength'	=> '100',
			'value'		=> $this->form_validation->set_value('rlegal_nombre', $proponentes->rlegal_nombre),
			'data-src'	=> $proponentes->rlegal_nombre,
			'class'		=> 'form-control'
		);

		$this->data['rlegal_apellido'] = array(
			'type'		=> 'text',
			'name'		=> 'rlegal_apellido',
			'id'		=> 'rlegal_apellido',
			'maxlength'	=> '100',
			'value'		=> $this->form_validation->set_value('rlegal_apellido', $proponentes->rlegal_apellido),
			'data-src'	=> $proponentes->rlegal_apellido,
			'class'		=> 'form-control'
		);

		$d_sexo = $this->Proponentes_model->concepto('SEXO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_sexo as $r_sexo) {
			$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
		}
		$this->data['rlegal_sexo'] = $a_sexo;
		$this->data['rlegal_sexo_sel'] = $proponentes->rlegal_sexo;	
		/* FIN - Agregando campos adicionales @Kevin Adorno*/
		
		/* Load Template */
		$this->template->admin_render('proponentes/edit', $this->data);
	}

	//////----------------------------------------//////
	//////                 view()               //////
	//////----------------------------------------//////

	public function view($proponente)
	{


		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $proponente OR empty($proponente))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proponentes_edit'), 'proponentes/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$proponentes = $this->Proponentes_model->view('proponentes', array('id_proponente' => $proponente))->row();

		/* Validate form input */
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('cedularuc' , 'lang:proponentes_cedularuc' , 'is_numeric|min_length[4]|max_length[9]|regex_match[/^([0-9]{4,9})?$/]');
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('apellido' , 'lang:proponentes_apellido' , 'max_length[100]');
		$this->form_validation->set_rules('email' , 'lang:proponentes_email' , 'max_length[100]');
		$this->form_validation->set_rules('fecha_nac', 'Date', 'callback_valid_date');
		$this->form_validation->set_rules('sexo' , 'lang:proponentes_sexo' , 'max_length[1]');
		$this->form_validation->set_rules('tipo_persona' , 'lang:proponentes_tipo_persona' , 'max_length[1]');
		$this->form_validation->set_rules('telefono' , 'lang:proponentes_telefono' , 'max_length[30]');
		$this->form_validation->set_rules('direccion' , 'lang:proponentes_direccion' , 'max_length[100]');
		$this->form_validation->set_rules('tipo_empresa' , 'lang:proponentes_tipo_empresa' , 'max_length[1]');
		$this->form_validation->set_rules('nacionalidad' , 'lang:proponentes_nacionalidad' , 'max_length[30]');
		$this->form_validation->set_rules('rlegal_cedula', 'Representante Legal Cedula', 'max_length[10]');
        $this->form_validation->set_rules('rlegal_nombre', 'Representante Legal Nombre', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_apellido', 'Representante Legal Apellido', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_sexo', 'Representante Legal Sexo', 'max_length[1]');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{

				/*if ($_POST['id_proponente']) {
					$arraycampos['id_proponente']					= strtoupper($_POST['id_proponente']);
				}
				*/

				if ($_POST['cedularuc']) {
					$arraycampos['cedularuc']					= $_POST['cedularuc'];
				}else{
					$arraycampos['cedularuc']					= NULL;
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']						= $_POST['nombre'];
				}else{
					$arraycampos['nombre']					= NULL;
				}	

				if ($_POST['apellido']) {
					$arraycampos['apellido']					= $_POST['apellido'];
				}else{
					$arraycampos['apellido']					= NULL;
				}

				if ($_POST['email']) {
					$arraycampos['email']						= $_POST['email'];
				}else{
					$arraycampos['email']					= NULL;
				}

				if ($_POST['fecha_nac']) {
					$arraycampos['fecha_nac']					= $_POST['fecha_nac'];
				} else {
					$arraycampos['fecha_nac']					= NULL;  
				}


				if ($_POST['dp_sexo']) {
					$arraycampos['sexo']						= $_POST['dp_sexo'];
				}else{
					$arraycampos['sexo']					= NULL;
				} 

				if ($_POST['dp_clientes']) {
					$arraycampos['id_cliente']		= $_POST['dp_clientes'];
				}else{
					$arraycampos['id_cliente']		= 	NULL;
				}


				if ($_POST['dp_tipo_persona']) {
					$arraycampos['tipo_persona']				= $_POST['dp_tipo_persona'];
				}else{
					$arraycampos['tipo_persona']					= NULL;
				}


				if ($_POST['telefono']) {
					$arraycampos['telefono']					= $_POST['telefono'];
				}else{
					$arraycampos['telefono']					= NULL;
				}


				if ($_POST['direccion']) {
					$arraycampos['direccion']					= $_POST['direccion'];
				}else{
					$arraycampos['direccion']					= NULL;
				}


				if ($_POST['dp_tipo_empresa']) {
					$arraycampos['tipo_empresa']				= $_POST['dp_tipo_empresa'];
				}else{
					$arraycampos['tipo_empresa']					= NULL;
				}


				if ($_POST['nacionalidad']) {
					$arraycampos['nacionalidad']				= $_POST['nacionalidad'];
				}else{
					$arraycampos['nacionalidad']					= NULL;
				}

				if ($_POST['rlegal_cedula']) {
					$arraycampos['rlegal_cedula']               = $_POST['rlegal_cedula'];
				}else{
					$arraycampos['rlegal_cedula']					= NULL;
				}
	
				if ($_POST['rlegal_nombre']) {
					$arraycampos['rlegal_nombre'] 				= $_POST['rlegal_nombre'];
				}else{
					$arraycampos['rlegal_nombre']					= NULL;
				}
	
				if ($_POST['rlegal_apellido']) {
					$arraycampos['rlegal_apellido'] 			= $_POST['rlegal_apellido'];
				}else{
					$arraycampos['rlegal_apellido']					= NULL;
				}
	
				if ($_POST['dp_rlegal_sexo']) {
					$arraycampos['rlegal_sexo'] 				= $_POST['dp_rlegal_sexo'];
				}else{
					$arraycampos['rlegal_sexo']					= NULL;
				}
	
			/*
	        echo '<pre>';
	        print_r( $arraycampos );
	        echo '</pre>';
	        show_error(1); 
			*/
				$proponente_update = $this->Proponentes_model->update_proponentes($proponentes->id_proponente,$arraycampos);

				if ($proponente_update)
				{

					$this->session->set_flashdata('message', $this->lang->line('proponentes_update_successful'));
					redirect('proponentes/Proponentes/edit/'.$proponentes->id_proponente); 
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['proponentes']   = $proponentes;

		//creando campos
		$this->data['id_proponente'] = array(
			'type'     => 'text',
			'name'     => 'id_proponente',
			'id'       => 'id_proponente',
			'value'    => $this->form_validation->set_value('id_proponente', $proponentes->id_proponente),
			'data-src' => $proponentes->id_proponente,
			'class'    => 'form-control',
			'disabled'    => true,
			'readonly' => 'readonly'
		);
		 
		$this->data['cedularuc'] = array(
			'type'     => 'text',
			'name'     => 'cedularuc',
			'id'       => 'cedularuc',
			'value'    => $this->form_validation->set_value('cedularuc', $proponentes->cedularuc),
			'data-src' => $proponentes->cedularuc,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);

		$this->data['nombre'] = array(
			'type'     => 'text',
			'name'     => 'nombre',
			'id'       => 'nombre',
			'value'    => $this->form_validation->set_value('nombre', $proponentes->nombre),
			'data-src' => $proponentes->nombre,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);

		$this->data['apellido'] = array(
			'type'     => 'text',
			'name'     => 'apellido',
			'id'       => 'apellido',
			'value'    => $this->form_validation->set_value('apellido', $proponentes->apellido),
			'data-src' => $proponentes->apellido,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);

		$this->data['email'] = array(
			'type'     => 'text',
			'name'     => 'email',
			'id'       => 'email',
			'value'    => $this->form_validation->set_value('email', $proponentes->email),
			'data-src' => $proponentes->email,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);	

		$this->data['fecha_nac'] = array(
			'type'     => 'text',
			'name'     => 'fecha_nac',
			'id'       => 'fecha_nac',
			'value'    => $this->form_validation->set_value('fecha_nac', formato_fecha($proponentes->fecha_nac)),
			'data-src' => $proponentes->fecha_nac,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);		

		$d_sexo = $this->Proponentes_model->concepto('SEXO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_sexo as $r_sexo) {
			$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
		}
		$this->data['sexo'] = $a_sexo;
		$this->data['sexo_sel'] = $proponentes->sexo;	

		$d_tipopersona = $this->Proponentes_model->concepto('TIPO_PERSONA',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_tipopersona as $r_tipopersona) {
			$a_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'].' - '.$r_tipopersona['nombre'];
		}
		$this->data['tipo_persona'] = $a_tipopersona;
		$this->data['tipo_persona_sel'] = $proponentes->tipo_persona;	

		$this->data['telefono'] = array(
			'type'     => 'text',
			'name'     => 'telefono',
			'id'       => 'telefono',
			'value'    => $this->form_validation->set_value('telefono', $proponentes->telefono),
			'data-src' => $proponentes->telefono,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);		

		$this->data['direccion'] = array(
			'type'     => 'text',
			'name'     => 'direccion',
			'id'       => 'direccion',
			'value'    => $this->form_validation->set_value('direccion', $proponentes->direccion),
			'data-src' => $proponentes->direccion,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);		

		$d_tipoempresa = $this->Proponentes_model->concepto('TIPO_EMPRESA',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_tipoempresa as $r_tipoempresa) {
			$a_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'].' - '.$r_tipoempresa['nombre'];
		}
		$this->data['tipo_empresa'] = $a_tipoempresa;
		$this->data['tipo_empresa_sel'] = $proponentes->tipo_empresa;	
			
		$a_clientes[''] = 'Seleccione el Cliente';
		$d_clientes = $this->Proponentes_model->dropdown_data('cliente')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_clientes as $r_cliente) {
			$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'].' - '.$r_cliente['nombre'].' '.$r_cliente['apellido'];
		}
		$this->data['cliente'] = $a_clientes;
		$this->data['cliente_sel'] = $proponentes->id_cliente;

		$this->data['nacionalidad'] = array(
			'type'     => 'text',
			'name'     => 'nacionalidad',
			'id'       => 'nacionalidad',
			'value'    => $this->form_validation->set_value('nacionalidad', $proponentes->nacionalidad),
			'data-src' => $proponentes->nacionalidad,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);
		
		/* INICIO - Agregando campos adicionales @Kevin Adorno*/
		

		$this->data['rlegal_cedula'] = array(
			'type'      => 'number',
			'name'      => 'rlegal_cedula',
			'id'        => 'rlegal_cedula',
			'pattern'   => '^[0-9]{4,9}$',
			'minlength' => '4',	
			'maxlength' => '9',	
			'value'     => $this->form_validation->set_value('rlegal_cedula', $proponentes->rlegal_cedula),
			'data-src'  => $proponentes->rlegal_cedula,
			'class'     => 'form-control',
			'readonly' => 'readonly'
		);

		$this->data['rlegal_nombre'] = array(
			'type'		=> 'text',
			'name'		=> 'rlegal_nombre',
			'id'		=> 'rlegal_nombre',
			'maxlength'	=> '100',
			'value'		=> $this->form_validation->set_value('rlegal_nombre', $proponentes->rlegal_nombre),
			'data-src'	=> $proponentes->rlegal_nombre,
			'class'		=> 'form-control',
			'readonly' => 'readonly'
		);

		$this->data['rlegal_apellido'] = array(
			'type'		=> 'text',
			'name'		=> 'rlegal_apellido',
			'id'		=> 'rlegal_apellido',
			'maxlength'	=> '100',
			'value'		=> $this->form_validation->set_value('rlegal_apellido', $proponentes->rlegal_apellido),
			'data-src'	=> $proponentes->rlegal_apellido,
			'class'		=> 'form-control',
			'readonly' => 'readonly'
		);

		$d_sexo = $this->Proponentes_model->concepto('SEXO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_sexo as $r_sexo) {
			$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
		}
		$this->data['rlegal_sexo'] = $a_sexo;
		$this->data['rlegal_sexo_sel'] = $proponentes->rlegal_sexo;	
		/* FIN - Agregando campos adicionales @Kevin Adorno*/
		
		/* Load Template */
		$this->template->admin_render('proponentes/views', $this->data);
	}

	

	//////----------------------------------------//////
	//////                 delete()               //////
	//////----------------------------------------//////
	public function delete($proponente)
	{
		$cnt_reg = $this->Proponentes_model->cnt_proponentes_reg_layers($proponente);
		if ($cnt_reg == 0) {

			$eliminar_proponente = $this->Proponentes_model->eliminar_proponentes($proponente);
			$this->session->set_flashdata('message', 'Se elimino el proponente! <b>');
			redirect('proponentes/proponentes/index/');
		}else{
			$this->session->set_flashdata('message', 'NO se pude eliminar porque tiene registros dependientes! <b>');
			redirect('proponentes/proponentes/index/');
		}
	}



	/////////////////////////////// VER PORTAL DE MAPAS ///////////////////// 
	public function verproponentes_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/ema/index.html?tipo_consulta=lotes_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}


	public function generar_proponentes ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ferramentas/imprimirema/Mapa_A3_f2_generar_proponente_tipo.php";
			redirect($i_jameuge);
	}

	

	
}